#include <bits/stdc++.h>

using namespace std;

const int MAX_N = 2*1e5 + 100;
const int long long MAX_Val = 1e12 + 100;

int n;
int long long paintArray[MAX_N];
vector<int> nodes[MAX_N];
int long long effectArray[MAX_N];
bool solutionNodes[MAX_N];

// Boji
vector<int> blue;
vector<int> red;
bool bio[MAX_N];
void paint(int node, bool first)
{
    //cout<<"T"<<endl;
    if(bio[node])
    {
        return;
    }
    bio[node] = true;

    if(solutionNodes[node])
    {
        if(first)
        {
            blue.push_back(node + 1);
        }
        else
        {
            red.push_back(node + 1);
        }
    }

    for(int i=0;i<nodes[node].size();i++)
    {
        paint(nodes[node][i], !first);
    }
}

// Proverava da li smo pokrili sva polja
bool covered[MAX_N];
bool painted[MAX_N];
bool allCovered()
{
    for(int i=0;i<n;i++)
    {
        if(!covered[i])
        {
            return false;
        }
    }

    return true;
}

// Koliko cvorova bio pokrio dati cvor
bool nextToPainted(int ind)
{
    for(int i=0;i<nodes[ind].size();i++)
    {
        if(painted[nodes[ind][i]])
        {
            return true;
        }
    }

    return false;
}

// Da li ce nesto pokriti ako ga obojimo
bool willCover(int ind)
{
    if(!covered[ind])
    {
        return true;
    }

    for(int i=0;i<nodes[ind].size();i++)
    {
        if(!covered[nodes[ind][i]])
        {
            return true;
        }
    }

    return false;
}

// Solve funkcija
void solve()
{
    // Dok nismo pokrili sva polja
    while(!allCovered())
    {
        // Najmanju i najbolji
        int index = -1;
        int long long minEffect = MAX_Val;
        for(int i=0;i<n;i++)
        {
            if(!painted[i] and ((effectArray[i] < minEffect and willCover(i)) or (effectArray[i] == minEffect and !nextToPainted(i) and willCover(i))))
            {
                minEffect = effectArray[i];
                index = i;
            }
        }
        /*cout<<index+1<<" "<<minEffect<<" "<<nextToPainted(index)<<" "<<willCover(index)<<endl;
        for(int l=0;l<n;l++)
        {
            cout<<l<<": "<<effectArray[l]<<endl;
        }cout<<endl<<endl;*/
        covered[index] = true;
        painted[index] = true;
        solutionNodes[index] = true;

        // Menjamo
        for(int i=0;i<nodes[index].size();i++)
        {
            int prviSused = nodes[index][i];
            covered[prviSused] = true;

            // Prvo drugog suseda
            for(int j=0;j<nodes[prviSused].size();j++)
            {
                int drugiSused = nodes[prviSused][j];

                if(!covered[prviSused])
                {
                    effectArray[drugiSused] += paintArray[prviSused];
                }
            }

            // Potom prvog suseda
            effectArray[prviSused] += paintArray[index];
        }
    }
}

int main()
{
    // Ulaz
    cin>>n;
    for(int i=0;i<n;i++)
    {
        cin>>paintArray[i];
    }

    for(int i=0;i<n-1;i++)
    {
        int u,v;
        cin>>u>>v;

        u--;
        v--;

        nodes[u].push_back(v);
        nodes[v].push_back(u);
    }

    // Obrada
    for(int i=0;i<n;i++)
    {
        int long long sumDece = 0;
        for(int j=0;j<nodes[i].size();j++)
        {
            sumDece += paintArray[nodes[i][j]];
        }

        effectArray[i] = paintArray[i] - sumDece;
    }

    solve();

    // Racunamo sumu
    int long long x = 0;
    for(int i=0;i<n;i++)
    {
        if(solutionNodes[i])
        {
            x += paintArray[i];
        }
    }

    // Rasporedjujemo u dve grupe
    paint(0, true);

    //cout<<endl<<endl<<endl<<endl;

    // Izlaz
    cout<<x<<endl;
    cout<<blue.size()<<endl;
    for(int i=0;i<blue.size();i++)
    {
        cout<<blue[i]<<" ";
    }
    cout<<endl;
    cout<<red.size()<<endl;
    for(int i=0;i<red.size();i++)
    {
        cout<<red[i]<<" ";
    }
    cout<<endl;

    return 0;
}